#include <AccelStepper.h>
#include <MultiStepper.h>

// Define stepper motor connections and motor interface type. Motor interface type must be set to 1 when using a driver:
const int dirPin = 5; //Direction pin 
const int stepPin =  2; //Stepper pin 
const int motorInterfaceType = 1; //Setting for Accel stepper
const int inputPin = 12; // TTL (not used later on in code, redefined)
const int EN = 8; //Enable pin - what determines if current output or not. Motor draws current when still, unless disable this pin
const int offset = 0; //Offset to fast axis of waveplate. 

//Setting up acceleration
AccelStepper stepper =  AccelStepper(motorInterfaceType,stepPin,dirPin);
void setup() {
  // put your setup code here, to run once:
  // Set up stepper code, and pins
  stepper.setAcceleration(float (200000)); //How fast (step/s/s)
  stepper.setMaxSpeed(float (25000)); //Don't change - hopefully won't reach  (step/s)
  stepper.setMinPulseWidth(1);
  stepper.enableOutputs();
  pinMode(EN,OUTPUT);
  pinMode(stepPin,OUTPUT);
  pinMode(dirPin,OUTPUT);
  digitalWrite(EN,LOW); 
  stepper.setCurrentPosition(0);

}
void loop() {
  // put your main code here, to run repeatedly:
  while (digitalRead(12)==0){} // Waiting for high trigger
  // digitalWrite(EN,LOW); // code to enable motor
  
  stepper.moveTo(100+offset);
  stepper.runToPosition();
  delay(10);
  // digitalWrite(EN,HIGH);// disable motor
  while (digitalRead(12)==1){}
  // digitalWrite(EN,LOW);// enable motor
  stepper.moveTo(0+offset);
  stepper.runToPosition();
  delay(5000);
  // digitalWrite(EN,HIGH);// disable motor
}
